/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rbf.impl;

import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.rbf.RbfRequestId;
import com.ibm.hwmca.fw.rbf.impl.RbfReply;
import com.ibm.hwmca.fw.util.Trace;

class AbortReply
implements RbfReply {
    private static final String TRACE_MASKT = "XRBFAMRT";
    private static final String TRACE_MASKF = "XRBFAMRF";
    private static final String TRACE_MASKD = "XRBFAMRD";
    private static final long serialVersionUID = -2678342245790704422L;
    private RbfRequestId requestId;
    private int status;
    static final int STATUS_ABORTED = 0;
    static final int STATUS_PENDING = 4;

    AbortReply(RbfRequestId requestId) {
        this(requestId, 0);
    }

    AbortReply(RbfRequestId requestId, int status) {
        if (requestId == null) {
            throw new IllegalArgumentException("Null request identifier specified");
        }
        if (!this.isValidStatus(status)) {
            throw new IllegalArgumentException("Invalid status specified");
        }
        this.requestId = requestId;
        this.status = status;
        Trace.trace(TRACE_MASKT, "<> " + this.toString());
    }

    boolean isValidStatus(int status) {
        switch (status) {
            case 0: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    RbfRequestId getRequestId() {
        return this.requestId;
    }

    int getStatus() {
        return this.status;
    }

    public void process(MachineId sender2, int protocol) {
        Trace.trace(TRACE_MASKT, "-> process()");
        Trace.trace(TRACE_MASKT, "<- process()");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[AbortReply: reqId=" + this.requestId + ", status=" + this.status + "]");
        return sb.toString();
    }
}

